﻿using System;
using System.Drawing;
using System.Runtime.InteropServices;

namespace PWS.API.Graphics
{
    public static class API
    {
        /// <summary>
        /// دسترسی به هندل بافت گرافیکی یک پنجره خاص
        /// </summary>
        /// <param name="hWnd">هندل پنجره مورد نظر</param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern IntPtr GetDC(IntPtr hWnd);

        /// <summary>
        /// دسترسی به هندل بافت گرافیکی یک پنجره خاص
        /// </summary>
        /// <param name="hWnd">هندل پنجره مورد نظر</param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern IntPtr GetWindowDC(IntPtr hWnd);

        /// <summary>
        /// بافت گرافیکی پنجره را ازاد می کند
        /// </summary>
        /// <param name="hDC">هندل بافت گرافیکی</param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern bool DeleteDC(IntPtr hDC);

        /// <summary>
        /// بافت گرافیکی پنجره مورد نظر را آزاد می کند
        /// </summary>
        /// <param name="hWnd">هندل پنجره</param>
        /// <param name="hDC">هندل بافت گرافیکی پنجره</param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern bool ReleaseDC(
            IntPtr hWnd, IntPtr hDC);

        /// <summary>
        /// انتقال اشاره گر نقطه فعال در بافت گرافیکی
        /// </summary>
        /// <param name="hDC">هندل یافت گرافیکی</param>
        /// <param name="x">مختصات نقطه در محور افقی</param>
        /// <param name="y">مختصات نقطه در محور عمودی</param>
        /// <param name="lpPoint">نقطه فعال قبلی</param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern bool MoveToEx(
            IntPtr hDC, int x, int y, IntPtr lpPoint);

        //System.Drawing.ColorTranslator.ToWin32()
        //

        /// <summary>
        /// نوع شمارشی جهت انتخاب نوع قلم
        /// </summary>
        [Flags]
        public enum PenStyle
        {
            PS_Solid = 0,
            PS_Dash = 1,
            PS_Dot = 2,
            PS_DashDot = 3,
            PS_DashDotDot = 4,
            PS_Null = 5,
            PS_InSideFrame = 6,
            PS_UserStyle = 7,
            PS_Alternate = 8,
            PS_StyleMask = 0x0000000F,

            PS_EndCapRound = 0x00000000,
            PS_EndCapSquare = 0x00000100,
            PS_EndCapFlat = 0x00000200,
            PS_EndCapMask = 0x00000F00,

            PS_JoinRound = 0x00000000,
            PS_JoinBevel = 0x00001000,
            PS_JoinMiter = 0x00002000,
            PS_JoinMask = 0x0000F000,

            PS_CosMetric = 0x00000000,
            PS_GeoMetric = 0x00010000,
            PS_TypeMask = 0x000F0000
        }

        /// <summary>
        /// ایجاد یک قلم جدید
        /// </summary>
        /// <param name="penStyle">طرح قلم</param>
        /// <param name="nWidth">ضخامت قلم</param>
        /// <param name="penColor">رنگ قلم</param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern IntPtr CreatePen(
            PenStyle penStyle, int nWidth, int penColor);

        /// <summary>
        /// جهت انتخاب یک الگوی خاص مانند قلم و طرح پس زمینه و ... برای بافت گرافیکی مورد نظر
        /// </summary>
        /// <param name="hDC">هندل بافت گرافیکی</param>
        /// <param name="hObject">هندل شی مورد نظر جهت استفاده در بافت گرافیکی</param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern IntPtr SelectObject(
            IntPtr hDC, IntPtr hObject);

        /// <summary>
        /// حذف یک شی از حافظه
        /// </summary>
        /// <param name="hObject">هندل شی مورد نظر</param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern bool DeleteObject(IntPtr hObject);

        /// <summary>
        /// ترسیم یک خط از نقطه جاری تا نقطه مشخص شده در بافت گرفیکی مورد نظر
        /// </summary>
        /// <param name="hDC">هندل بافت گرافیکی</param>
        /// <param name="nXEnd">مختصات افقی نقطه پایانی خط</param>
        /// <param name="nYEnd">مختصات عمودی نقطه پایانی خط</param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern bool LineTo(
            IntPtr hDC, int nXEnd, int nYEnd);

        /// <summary>
        /// بدست آوردن هندل کل پنجره یک بافت گرافیکی مشخص
        /// </summary>
        /// <param name="hDC">هندل بافت گرافیکی</param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern IntPtr WindowFromDC(IntPtr hDC);

        //***************************************************
        /// <summary>
        /// رسم کمان
        /// </summary>
        /// <param name="hDC"></param>
        /// <param name="nLeftRect"></param>
        /// <param name="nTopRect"></param>
        /// <param name="nRightRect"></param>
        /// <param name="nBottomRect"></param>
        /// <param name="nXStartArc"></param>
        /// <param name="nYStartArc"></param>
        /// <param name="nXEndArc"></param>
        /// <param name="nYEndArc"></param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern bool Arc(
            IntPtr hDC, 
            int nLeftRect, 
            int nTopRect, 
            int nRightRect, 
            int nBottomRect, 
            int nXStartArc, 
            int nYStartArc, 
            int nXEndArc, 
            int nYEndArc);

        /// <summary>
        /// رسم کمان
        /// </summary>
        /// <param name="hDC">The h DC.</param>
        /// <param name="nLeftRect">The n left rect.</param>
        /// <param name="nTopRect">The n top rect.</param>
        /// <param name="nRightRect">The n right rect.</param>
        /// <param name="nBottomRect">The n bottom rect.</param>
        /// <param name="nXStartArc">The n X start arc.</param>
        /// <param name="nYStartArc">The n Y start arc.</param>
        /// <param name="nXEndArc">The n X end arc.</param>
        /// <param name="nYEndArc">The n Y end arc.</param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern bool ArcTo(
            IntPtr hDC, int nLeftRect, 
            int nTopRect, int nRightRect, 
            int nBottomRect, int nXStartArc, 
            int nYStartArc, int nXEndArc, int nYEndArc);

        /// <summary>
        /// رسم کمان و یک خط متصل به ان
        /// </summary>
        /// <param name="hDC">The h DC.</param>
        /// <param name="x">The x.</param>
        /// <param name="y">The y.</param>
        /// <param name="dwRadius">The dw radius.</param>
        /// <param name="eStartAngle">The e start angle.</param>
        /// <param name="eSweepAngle">The e sweep angle.</param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern bool AngleArc(
            IntPtr hDC, int x, int y, 
            uint dwRadius, float eStartAngle, 
            float eSweepAngle);

        /// <summary>
        /// رسم بیضی
        /// </summary>
        /// <param name="hDC">The h DC.</param>
        /// <param name="nLeftRect">The n left rect.</param>
        /// <param name="nTopRect">The n top rect.</param>
        /// <param name="nRightRect">The n right rect.</param>
        /// <param name="nBottomRect">The n bottom rect.</param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern bool Ellipse(
            IntPtr hDC, 
            int nLeftRect, 
            int nTopRect, 
            int nRightRect, 
            int nBottomRect);

        /// <summary>
        /// ترسیم خطوط آزاد متصل به هم
        /// </summary>
        /// <param name="hDC">هندل بافت گرافیکی</param>
        /// <param name="lpPoints">آرایه ای از نقاط</param>
        /// <param name="pointsCount">تعداد نقاط</param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern bool PolyBezierTo(
            IntPtr hDC, Point[] lpPoints, int pointsCount);

        /// <summary>
        /// رسم چند ضلعی
        /// </summary>
        /// <param name="hDC">هندل بافت گرافیکی</param>
        /// <param name="lpPoints">رئوس چند ضلعی</param>
        /// <param name="pointsCount">تعداد رئوس</param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern bool Polygon(
            IntPtr hDC, Point[] lpPoints, int pointsCount);

        /// <summary>
        /// خط های بهم پیوسته رسم می کند
        /// </summary>
        /// <param name="hDC">هندل بافت گرافیکی</param>
        /// <param name="lpPoints">ارایه ای از نقاط</param>
        /// <param name="pointsCount">تعداد نقاط</param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern bool Polyline(
            IntPtr hDC, Point[] lpPoints, int pointsCount);

        /// <summary>
        /// خط های بهم پیوسته رسم می کند نقطه شروع نقطه فعال بافت گرافیکی است
        /// </summary>
        /// <param name="hDC">هندل بافت گرافیکی</param>
        /// <param name="lpPoints">ارایه ای از نقاط</param>
        /// <param name="pointsCount">تعداد نقاط</param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern bool PolylineTo(
            IntPtr hDC, Point[] lpPoints, int pointsCount);

        /// <summary>
        /// ترسیم یکباره چند سری خط پیوسته
        /// </summary>
        /// <param name="hDC">هندل بافت گرافیکی</param>
        /// <param name="lpPoints">ارایه ای از نقاط</param>
        /// <param name="lpdwPolyPoints">ارایه ای از تعداد نقاط هر سری خط بهم پیوسته</param>
        /// <param name="ppCount">تعداد خانه های (تعداد نقاط)ارایه تعداد نقاط خطوط بهم پیوسته</param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern bool PolyPolyline(
            IntPtr hDC, Point[] lpPoints, int[] lpdwPolyPoints, int ppCount);

        /// <summary>
        /// رسم یک قطاع از دایره
        /// </summary>
        /// <param name="hDC"></param>
        /// <param name="nLeftRect"></param>
        /// <param name="nTopRect"></param>
        /// <param name="nRightRect"></param>
        /// <param name="nBottomRect"></param>
        /// <param name="nXRadial1"></param>
        /// <param name="nYRadial1"></param>
        /// <param name="nXRadial2"></param>
        /// <param name="nYRadial2"></param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern bool Pie(
            IntPtr hDC, 
            int nLeftRect, 
            int nTopRect, 
            int nRightRect, 
            int nBottomRect, 
            int nXRadial1, 
            int nYRadial1, 
            int nXRadial2, 
            int nYRadial2);

        /// <summary>
        /// رسم چند شکل چند ضلعی در یک باز فراخوانی
        /// </summary>
        /// <param name="hDC"></param>
        /// <param name="lpPoints"></param>
        /// <param name="lpdwPolyPoints"></param>
        /// <param name="ppCount"></param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern bool PolyPolygon(
            IntPtr hDC, Point[] lpPoints, int[] lpdwPolyPoints, int ppCount);

        /// <summary>
        /// رسم چهار گوش با گوشه های گرد
        /// </summary>
        /// <param name="hDC">The h DC.</param>
        /// <param name="nLeftRect">The n left rect.</param>
        /// <param name="nTopRect">The n top rect.</param>
        /// <param name="nRightRect">The n right rect.</param>
        /// <param name="nBottomRect">The n bottom rect.</param>
        /// <param name="nWidth">Width of the n.</param>
        /// <param name="nHeight">Height of the n.</param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern bool RoundRect(
            IntPtr hDC, int nLeftRect, int nTopRect, 
            int nRightRect, int nBottomRect, int nWidth, int nHeight);

        /// <summary>
        /// رسم چهار گوش
        /// </summary>
        /// <param name="hDC">The h DC.</param>
        /// <param name="nLeftRect">The n left rect.</param>
        /// <param name="nTopRect">The n top rect.</param>
        /// <param name="nRightRect">The n right rect.</param>
        /// <param name="nBottomRect">The n bottom rect.</param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern bool Rectangle(
            IntPtr hDC, int nLeftRect, int nTopRect, int nRightRect, int nBottomRect);

        [DllImport("gdi32.dll")]
        public static extern IntPtr CreatePatternBrush(IntPtr hbmp);

        /// <summary>
        /// یک قلم رنگی برای رنگ کردن نواحی وشکل ها ایجاد می کند
        /// </summary>
        /// <param name="crColor">کد رنگ</param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern IntPtr CreateSolidBrush(int crColor);

        /// <summary>
        /// پر کردن یک چهار گوش با براش دلخواه
        /// </summary>
        /// <param name="hDC">هندل بافت گرافیکی</param>
        /// <param name="lpRect">محدوده چهار گوش</param>
        /// <param name="hBrush">براش مورد نظر</param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern bool FillRect(
            IntPtr hDC, [In] ref Rectangle lpRect, IntPtr hBrush);

        /// <summary>
        /// ایجاد یک قلم هاشور دلخواه
        /// </summary>
        /// <param name="fnStyle">نوع هاشور</param>
        /// <param name="crColor">رنگ هاشور</param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern IntPtr CreateHatchBrush(
            CreateHatchBrushType fnStyle, int crColor);

        public enum CreateHatchBrushType
        {
            HS_BDiagonal = 0x3,
            HS_Cross = 0x4,
            HS_DiagonalCross = 0x5,
            HS_FDiagonal = 0x2,
            HS_Horizontal = 0x0,
            HS_Vertical = 0x1
        }

        /// <summary>
        /// ایجاد یک ناحیه بیضوی
        /// </summary>
        /// <param name="nLeftRect">The n left rect.</param>
        /// <param name="nTopRect">The n top rect.</param>
        /// <param name="nRightRect">The n right rect.</param>
        /// <param name="nBottomRect">The n bottom rect.</param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern IntPtr CreateEllipticRgn(
            int nLeftRect, int nTopRect, int nRightRect, int nBottomRect);

        /// <summary>
        /// ایجاد یک ناحیه بیضوی
        /// </summary>
        /// <param name="lpRect">The lp rect.</param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern IntPtr CreateEllipticRgnIndirect([In] ref Rectangle lpRect);

        /// <summary>
        /// ساخت یک ناحیه چهار گوش
        /// </summary>
        /// <param name="nLeftRect">The n left rect.</param>
        /// <param name="nTopRect">The n top rect.</param>
        /// <param name="nRightRect">The n right rect.</param>
        /// <param name="nBottomRect">The n bottom rect.</param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern IntPtr CreateRectRgn(
            int nLeftRect, int nTopRect, int nRightRect, int nBottomRect);

        /// <summary>
        /// ساخت یک ناحیه چهار گوش
        /// </summary>
        /// <param name="lpRect"></param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern IntPtr CreateRectRgnIndirect([In] ref Rectangle lpRect);

        /// <summary>
        /// ساخت یک ناحیه چهار گوش با گوشه های گرد
        /// </summary>
        /// <param name="nLeftRect">The n left rect.</param>
        /// <param name="nTopRect">The n top rect.</param>
        /// <param name="nRightRect">The n right rect.</param>
        /// <param name="nBottomRect">The n bottom rect.</param>
        /// <param name="nWidth">Width of the n.</param>
        /// <param name="nHeight">Height of the n.</param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern IntPtr CreateRoundRectRgn(
            int nLeftRect, int nTopRect, int nRightRect, 
            int nBottomRect, int nWidth, int nHeight);

        /// <summary>
        /// ایجاد یک ناحیه چند ضلعی
        /// </summary>
        /// <param name="lpPoints">The lp points.</param>
        /// <param name="pointsCount">The points count.</param>
        /// <param name="fnPolyFillMode">The fn poly fill mode.</param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern IntPtr CreatePolygonRgn(
            Point[] lpPoints, int pointsCount, int fnPolyFillMode);

        /// <summary>
        /// ایجاد چند ناحیه چند ضلعی
        /// </summary>
        /// <param name="lpPoints">The lp points.</param>
        /// <param name="lpdwPolyPoints">The LPDW poly points.</param>
        /// <param name="ppCount">The pp count.</param>
        /// <param name="fnPolyFillMode">The fn poly fill mode.</param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern IntPtr CreatePolyPolygonRgn(
            Point[] lpPoints, int[] lpdwPolyPoints, int ppCount, int fnPolyFillMode);

        /// <summary>
        /// پر کردن یک ناحیه دلخواه با نوع هاشور دلخواه
        /// </summary>
        /// <param name="hDC">The h DC.</param>
        /// <param name="hRgn">The h RGN.</param>
        /// <param name="hBrush">The h brush.</param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern bool FillRgn(
            IntPtr hDC, IntPtr hRgn, IntPtr hBrush);

        /// <summary>
        /// پر کردن یک محدوده خاص از بافت گرافیکی با رنگ و هاشور دلخواه
        /// </summary>
        /// <param name="hDC">The h DC.</param>
        /// <param name="nXStart">The n X start.</param>
        /// <param name="nYStart">The n Y start.</param>
        /// <param name="colorFill">The color fill.</param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern bool FloodFill(
            IntPtr hDC, int nXStart, int nYStart, int colorFill);

        [Flags]
        public enum DrawFrameControlTypes
        {
            DFC_Button = 0x4,
            DFC_Caption = 0x1,
            DFC_Menu = 0x2,
            DFC_PopupMenu = 0x5,
            DFC_Scroll = 0x3
        }

        [Flags]
        public enum DrawFrameControlStates
        {
            Button_Check = 0,
            Button_RadioImage = 1,
            Button_RadioMask = 2,
            Button_Radio = 4,
            Button_State = 8,
            Button_Push = 0x10,
            Caption_Close = 0,
            Caption_Minimize = 1,
            Caption_Maximize = 2,
            Caption_Restore = 3,
            Caption_Help = 4,
            Menu_Arrow = 0,
            Menu_Check = 1,
            Menu_Bullet = 2,
            Menu_ArrowRight = 4,
            Scroll_Up = 0,
            Scroll_Down = 1,
            Scroll_Left = 2,
            Scroll_Right = 3,
            Scroll_ComboBox = 5,
            Scroll_SizeGrip = 8,
            Scroll_SizeGripRight = 0x10,
            Rectangle_AdjastRectangle = 0x2000,
            State_Inactive = 0x100,
            State_Pushed = 0x200,
            State_Checked = 0x400,
            State_Transparent = 0x800,
            State_Hot = 0x1000,
            State_Flat = 0x4000,
            State_Mono = 0x8000
        }

        [DllImport("user32.dll")]
        public static extern bool DrawFrameControl(
            IntPtr hDC, [In] ref Rectangle lpRect, 
            DrawFrameControlTypes uType, DrawFrameControlStates uState);

        [DllImport("user32.dll")]
        public static extern bool DrawEdge(
            IntPtr hDC, ref Rectangle qRect, int edge, int grfFlags);

        /// <summary>
        /// معکوس نمودن رنگ یک ناحیه مشخص
        /// </summary>
        /// <param name="hDC">The h DC.</param>
        /// <param name="hRgn">The h RGN.</param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern bool InvertRgn(IntPtr hDC, IntPtr hRgn);

        /// <summary>
        /// تغییر مکان یک ناحیه خاص
        /// </summary>
        /// <param name="hRgn">The h RGN.</param>
        /// <param name="nXOffset">The n X offset.</param>
        /// <param name="nYOffset">The n Y offset.</param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern int OffsetRgn(
            IntPtr hRgn, int nXOffset, int nYOffset);

        [DllImport("gdi32.dll")]
        public static extern bool CombineRgn(
            IntPtr hRgnDest, IntPtr hRgnSrc1, 
            IntPtr hRgnSrc2, CombineRgnStyles fnCombineMode);

        public enum CombineRgnStyles : int
        {
            RGN_And = 1,
            RGN_OR = 2,
            RGN_XOR = 3,
            RGN_Diff = 4,
            RGN_Copy = 5,
            RGN_Min = RGN_And,
            RGN_Max = RGN_Copy
        }

        /// <summary>
        /// رنگی کردن یک پیکسل خاص
        /// </summary>
        /// <param name="hDC"></param>
        /// <param name="x"></param>
        /// <param name="y"></param>
        /// <param name="crColor"></param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern bool SetPixel(
            IntPtr hDC, int x, int y, int crColor);

        /// <summary>
        /// رنگی کردن یک پیکسل خاص
        /// </summary>
        /// <param name="hDC"></param>
        /// <param name="x"></param>
        /// <param name="y"></param>
        /// <param name="crColor"></param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern bool SetPixelV(
            IntPtr hDC, int x, int y, int crColor);

        [DllImport("gdi32.dll")]
        public static extern int GetPixel(IntPtr hDC, int nXPos, int nYPos);

        /// <summary>
        /// بازیابی رنگ پس زمینه بافت گرافیکی خاص
        /// </summary>
        /// <param name="hDC"></param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern int GetBkColor(IntPtr hDC);

        /// <summary>
        /// نمایش متن در یک نقطه دلخواه
        /// </summary>
        /// <param name="hDC"></param>
        /// <param name="nXStart"></param>
        /// <param name="nYStart"></param>
        /// <param name="lpString"></param>
        /// <param name="lpStringLength"></param>
        /// <returns></returns>
        [DllImport("gdi32.dll")]
        public static extern bool TextOut(
            IntPtr hDC, int nXStart, int nYStart, 
            string lpString, int lpStringLength);

        [DllImport("gdi32.dll", EntryPoint = "GdiGradientFill", ExactSpelling = true)]
        public static extern bool GradientFill(IntPtr hDC, TRIVertex[] pVertex, uint dwNumVertex, GradientRect[] pMesh, uint dwNumMesh, uint dwMode);

        public struct GradientRect
        {
            public uint UpperLeft;
            public uint LowerRight;

            public GradientRect(uint upLeft, uint lowRight)
            {
                UpperLeft = upLeft;
                LowerRight = lowRight;
            }
        }
        [StructLayout(LayoutKind.Sequential)]
        public struct GradientTriangle
        {
            uint Vertex1;
            uint Vertex2;
            uint Vertex3;
        }
        public struct TRIVertex
        {
            int X;
            int Y;
            ushort Red;
            ushort Green;
            ushort Blue;
            ushort Alpha;

            public TRIVertex(int x, int y, ushort red, ushort green, ushort blue, ushort alpha)
            {
                this.X = x;
                this.Y = x;
                this.Red = red;
                this.Green = green;
                this.Blue = blue;
                this.Alpha = alpha;
            }
        }

        public const uint GRADIENT_FILL_RECT_H = 0x00000000, GRADIENT_FILL_RECT_V = 0x00000001, GRADIENT_FILL_TRIANGLE = 0x00000002, GRADIENT_FILL_OP_FLAG = 0x000000ff;

        /// <summary>
        /// از صفحه دسکتاپ عکس می گیرد
        /// </summary>
        /// <param name="hDC">هندل بافت گرافیکی مقصد</param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern bool PaintDesktop(IntPtr hDC);
    }
}